import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:photogram_admin_cp/ui/pages/content/uploads/allowed_file_types.dart';
import 'package:photogram_admin_cp/ui/pages/content/uploads/content_limits.dart';
import 'package:photogram_admin_cp/ui/pages/content/uploads/image_quality.dart';
import 'package:photogram_admin_cp/ui/pages/content/uploads/image_resize.dart';

class UploadSettingsPage extends StatefulWidget {
  const UploadSettingsPage({Key? key}) : super(key: key);

  @override
  _UploadSettingsPageState createState() => _UploadSettingsPageState();
}

class _UploadSettingsPageState extends State<UploadSettingsPage> with AppActiveContentMixin {
  NavigatorState? _state;
  String _currentRoute = 'disks';

  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: navigatorContent(),
        ),
        Division(
          className: 'col-lg-3',
          children: [
            Division(
              className: 'content-sidebar',
              children: [
                Division(
                  className: 'on-this-page-nav',
                  children: [
                    const Division(className: 'title font-size-18', innerText: 'Content Control'),
                    Anchor(
                      className: _currentRoute == 'allowed' ? 'active' : '',
                      innerText: 'Allowed File Types',
                      onClick: (_) => _openRoute('allowed'),
                    ),
                    Anchor(
                      className: _currentRoute == 'limits' ? 'active' : '',
                      innerText: 'Content Upload Limits',
                      onClick: (_) => _openRoute('limits'),
                    ),
                  ],
                ),
                const LineBreak(),
                Division(
                  className: 'on-this-page-nav',
                  children: [
                    const Division(className: 'title font-size-18', innerText: 'Image Uploads'),
                    Anchor(
                      className: _currentRoute == 'resize' ? 'active' : '',
                      innerText: 'Compressed Resolution Options',
                      onClick: (_) => _openRoute('resize'),
                    ),
                    Anchor(
                      className: _currentRoute == 'quality' ? 'active' : '',
                      innerText: 'Compressed Quality Options',
                      onClick: (_) => _openRoute('quality'),
                    ),
                  ],
                ),
              ],
            ),
          ],
        ),
      ],
    );
  }

  Widget navigatorContent() {
    return Navigator(
      key: const Key('upload-settings-navigator'),
      onInit: (state) => _state = state,
      onRouteChange: _onRouteChange,
      routes: const [
        Route(name: 'allowed', page: AllowedFileTypesSection()),
        Route(name: 'limits', page: ContentLimitsSection()),
        Route(name: 'resize', page: ImageResizeSection()),
        Route(name: 'quality', page: ImageQualitySection()),
      ],
    );
  }

  void _openRoute(String name, [Map<String, String> values = const {}]) {
    _state?.open(name: name, values: values);
  }

  void _onRouteChange(String name) {
    Future.delayed(Duration.zero, () {
      setState(() {
        _currentRoute = name;
      });
    });
  }
}
